public without sharing class FmlReservationStep01Controller extends bfml.FmlReservationStep01ControllerIF {

    public override List<bfml__FmlResAbleService__c> getServicesList(String falicityCode) {
        return  [SELECT Id, Name,bfml__ServiceDetail__c, bfml__ReservationAvaliableObject__c,bfml__ServiceNecessaryTime__c  FROM bfml__FmlResAbleService__c WHERE bfml__ReservationAvaliableObject__r.bfml__ReservationObjectID__c = :falicityCode 
                AND bfml__IsActive__c = true order by bfml__DisplayOrder__c ];
    }
	
	public override List<bfml__FmlResAbleService__c> getServicesListById(String serviceId) {
        return [SELECT Id, Name,bfml__ServiceDetail__c, bfml__ReservationAvaliableObject__c,bfml__ServiceNecessaryTime__c FROM bfml__FmlResAbleService__c WHERE Id = :serviceId];
    }
	
    public override List<bfml__FmlResAbleTime__c> getReservationAvaliableTimes(String falicityId) {
        return [SELECT Id, bfml__RelatedReservationObject__c, bfml__TimeSectionType__c,bfml__SpecificDateList__c,bfml__StartTime__c, bfml__EndTime__c, bfml__ReserveMaxLimitLimit__c, bfml__DayInWeek__c, bfml__Closed__c 
            FROM bfml__FmlResAbleTime__c WHERE bfml__RelatedReservationObject__c = :falicityId AND  bfml__IsActive__c = true];
    }
    public override List<bfml__FmlResObject__c> getFalicityList(String falicityCode) {
        return [SELECT Id, Name, bfml__ReservationObjectID__c, bfml__ReservationCalenderTimeSection__c, bfml__ReservationCalTimeStart__c,bfml__ReservationCalTimeEnd__c,bfml__ReservationCalMaxWeeks__c,bfml__ReservationCalWarnCnt__c FROM bfml__FmlResObject__c WHERE bfml__ReservationObjectID__c = :falicityCode LIMIT 1];
    }

    public override List<bfml__FmlResData__c> getReservationById(String reservedId) {
        return [SELECT Id,bfml__LineId__c,bfml__ChannelID__c, bfml__ReservationDate__c,bfml__StartTime__c,bfml__ReservationObject__r.Name,bfml__ReservationAvaliableService__r.Name,bfml__Status__c,
                bfml__CommentText__c From bfml__FmlResData__c where Id = :reservedId];
    }
	
    public override List<bfml__FmlResData__c> getReservationByDate(String falicityId,Date reserveDate) {
        return [SELECT Id, bfml__ReservationObject__c,bfml__CanceledReservation__c, bfml__ReservationDate__c, bfml__ReservationAvaliableService__c, bfml__StartTime__c, bfml__EndTime__c ,bfml__Status__c
            FROM bfml__FmlResData__c WHERE (bfml__ReservationObject__c = :falicityId AND bfml__ReservationDate__c = :reserveDate) 
                OR (bfml__CanceledReservation__r.bfml__ReservationObject__c = :falicityId AND bfml__CanceledReservation__r.bfml__ReservationDate__c = :reserveDate AND bfml__Status__c ='キャンセル')];
    }
	
    public override List<bfml__FmlResData__c> getReservationByStartEnd(String falicityId,Date startDate,Date endDate) {
        return [SELECT Id, bfml__ReservationObject__c,bfml__Status__c,bfml__CanceledReservation__c, bfml__ReservationDate__c, bfml__ReservationAvaliableService__c, bfml__StartTime__c, bfml__EndTime__c 
            FROM bfml__FmlResData__c WHERE (bfml__ReservationObject__c = :falicityId AND bfml__ReservationDate__c >= :startDate AND bfml__ReservationDate__c <= :endDate) 
                    OR (bfml__CanceledReservation__r.bfml__ReservationObject__c = :falicityId AND bfml__CanceledReservation__r.bfml__ReservationDate__c >= :startDate 
                        AND bfml__CanceledReservation__r.bfml__ReservationDate__c <= :endDate AND bfml__Status__c = 'キャンセル') 
            ORDER BY bfml__ReservationDate__c ASC];
    }

    @RemoteAction
    public static String getCurrentReservationId(String channelId, String LineId, String falicityCode) {
        
       List<bfml__FmlResData__c> reservationDataList = [select id,bfml__Status__c from bfml__FmlResData__c where bfml__ChannelID__c =:channelId and bfml__LineId__c = :LineId 
                                                        and (bfml__ReservationObject__r.bfml__ReservationObjectID__c = :falicityCode 
                                                             OR bfml__CanceledReservation__r.bfml__ReservationObject__r.bfml__ReservationObjectID__c = :falicityCode) 
                                                        order by CreatedDate desc limit 1];

       //最新の予約データキャンセルではない場合、予約ありとし、該当予約データID返す
        if(!reservationDataList.isEmpty() && reservationDataList[0].bfml__Status__c != 'キャンセル') {
            return reservationDataList[0].Id;
        } else {
            return '';
        }
    }

    public override bfml__FmlResData__c insertData(bfml__FmlResData__c reservationData) {
        insert reservationData;
        bfml__FmlResData__c resData = [select id,Name,bfml__CanceledReservation__r.Name from bfml__FmlResData__c where id = :reservationData.Id];
        return resData;
    }
}